/*
 * Decompiled with CFR 0.152.
 */
package quentinc.sapi;

import quentinc.accessibility.Speech;

public class SAPISpeech
extends Speech {
    private static SAPISpeech inst;

    public static SAPISpeech getInstance() {
        if (inst == null) {
            inst = new SAPISpeech();
        }
        return inst;
    }

    private SAPISpeech() {
        System.loadLibrary("easysapi");
        if (!this.sapiInit()) {
            throw new RuntimeException("Couldn't initialize SAPI");
        }
    }

    public void finalize() {
        this.sapiFree();
    }

    private native boolean sapiInit();

    private native void sapiFree();

    @Override
    public native boolean sayString(String var1, boolean var2);

    public native boolean sayStringXML(String var1, boolean var2);

    public native boolean isSpeaking();

    @Override
    public native boolean setPaused(boolean var1);

    public native boolean isPaused();

    @Override
    public native boolean setRate(int var1);

    @Override
    public native int getRate();

    @Override
    public native boolean setVolume(int var1);

    @Override
    public native int getVolume();

    @Override
    public boolean isPausable() {
        return true;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public boolean isVolumeAdjustable() {
        return true;
    }

    @Override
    public boolean isRateAdjustable() {
        return true;
    }

    @Override
    public int getMinVolume() {
        return 0;
    }

    @Override
    public int getMaxVolume() {
        return 100;
    }

    @Override
    public int getMinRate() {
        return -10;
    }

    @Override
    public int getMaxRate() {
        return 10;
    }
}

