/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import quentinc.menu.AbstractMenuItem;
import quentinc.menu.ChoiceMenuItem;
import quentinc.menu.InputMenuItem;
import quentinc.menu.KeyStrokeMenuItem;
import quentinc.menu.MenuItem;
import quentinc.menu.SpinMenuItem;
import quentinc.menu.ToggleMenuItem;

public class Menu
extends MenuItem {
    protected static boolean insertDown = false;
    private boolean active = false;
    private boolean quickSelect = false;
    private List<MenuItem> items = new ArrayList<MenuItem>();
    private int current = 0;
    private String curInput = null;
    private long curInputTime = 0L;
    private static final int MAX_INPUT_TIME = 360;

    public static boolean isInsertDown() {
        return insertDown;
    }

    public Menu(String string) {
        super(string);
    }

    public boolean isExpanded() {
        return this.active;
    }

    public void setExpanded(boolean bl) {
        this.active = bl;
    }

    public boolean isQuickSelectionOn() {
        return this.quickSelect;
    }

    public void setQuickSelectionOn(boolean bl) {
        this.quickSelect = bl;
    }

    public void add(MenuItem menuItem) {
        menuItem.parent = this;
        this.items.add(menuItem);
    }

    public boolean remove(MenuItem menuItem) {
        menuItem.parent = null;
        return this.items.remove(menuItem);
    }

    public void clear() {
        this.items.clear();
    }

    public AbstractMenuItem getSelectedItem() {
        return this.getsel();
    }

    protected void changesel(int n) {
        if (!this.active) {
            return;
        }
        if (n >= 0 && n < this.items.size()) {
            if (this.items.get(this.current).leaveItem()) {
                this.current = n;
                this.items.get(this.current).enterItem();
            } else {
                this.notifyError(1);
            }
            this.notifySelectionChanged(0);
        }
    }

    @Override
    protected AbstractMenuItem getsel() {
        if (!this.active) {
            return this;
        }
        return this.items.get(this.current).getsel();
    }

    @Override
    public String getHelpString() {
        if (!this.active) {
            return super.getHelpString();
        }
        return this.items.get(this.current).getHelpString();
    }

    @Override
    public String getShortString() {
        if (!this.active) {
            return super.getShortString();
        }
        return this.items.get(this.current).getShortString();
    }

    @Override
    public String getLongString() {
        if (!this.active) {
            return super.getLongString();
        }
        return this.items.get(this.current).getLongString();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.active) {
            this.items.get(this.current).keyPressed(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (insertDown) {
                if (n == 38) {
                    this.notifyChanged();
                } else if (n == 9) {
                    this.notifySelectionChanged(0);
                }
            } else if (n == 38 || n == 9 && n2 == 1) {
                this.changesel((this.current + this.items.size() - 1) % this.items.size());
                keyEvent.consume();
            } else if (n == 40 || n == 9 && n2 == 0) {
                this.changesel((this.current + 1) % this.items.size());
                keyEvent.consume();
            }
        } else {
            int n = keyEvent.getKeyCode();
            if (n == 10 || n == 39) {
                this.setExpanded(true);
                this.notifySelectionChanged(1);
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.active) {
            this.items.get(this.current).keyReleased(keyEvent);
        }
        if (!keyEvent.isConsumed()) {
            super.keyReleased(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.active) {
            this.items.get(this.current).keyTyped(keyEvent);
        }
        if (!keyEvent.isConsumed()) {
            super.keyTyped(keyEvent);
        }
        if (this.quickSelect && !keyEvent.isConsumed() && this.active) {
            this.handleQuickSelect(keyEvent);
        }
    }

    private void handleQuickSelect(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c == '\uffff') {
            return;
        }
        long l = System.currentTimeMillis();
        int n = 1;
        if (l - this.curInputTime > 360L) {
            this.curInput = String.valueOf(c);
        } else if (this.curInput == null) {
            this.curInput = String.valueOf(c);
        } else {
            n = 0;
            this.curInput = this.curInput + c;
        }
        this.curInputTime = l;
        int n2 = this.findItemByLabel(this.curInput, n + this.current);
        if (n2 != -1) {
            this.current = n2;
            this.notifySelectionChanged(0);
            keyEvent.consume();
        }
    }

    public int findItemByLabel(String string, int n) {
        int n2;
        string = string.toLowerCase();
        for (n2 = n; n2 < this.items.size(); ++n2) {
            if (!this.items.get(n2).getLongString().toLowerCase().startsWith(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.items.get(n2).getLongString().toLowerCase().startsWith(string)) continue;
            return n2;
        }
        return -1;
    }

    public static void setStrings(ResourceBundle resourceBundle) {
        ChoiceMenuItem.setStrings(resourceBundle.getString("choiceHelp"));
        InputMenuItem.setStrings(resourceBundle.getString("selected"), resourceBundle.getString("inputHelp"));
        KeyStrokeMenuItem.setStrings(resourceBundle.getString("none"), resourceBundle.getString("keyAssign"), resourceBundle.getString("keyHelp"));
        MenuItem.setStrings(resourceBundle.getString("itemHelp"));
        SpinMenuItem.setStrings(resourceBundle.getString("spinHelp"));
        ToggleMenuItem.setStrings(resourceBundle.getString("checked"), resourceBundle.getString("notchecked"), resourceBundle.getString("toggleHelp"));
    }
}

