/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.event.KeyEvent;
import quentinc.menu.MenuItem;

public class KeyStrokeMenuItem
extends MenuItem {
    private static String none = "None";
    private int key = -1;
    private int mods = -1;
    private boolean capture = false;
    private static String help = "Press enter to modify the key binding, then press the key combination you would like to assign. Press delete to remove an existing assignment.";
    private static String readyToAssign = "Assign key binding to %s, current binding is %s.";

    public static void setStrings(String string, String string2, String string3) {
        none = string;
        readyToAssign = string2;
        help = string3;
    }

    @Override
    public String getHelpString() {
        return help;
    }

    @Override
    public String getLastUpdateString() {
        return String.format(readyToAssign, super.getLongString(), this.getShortString());
    }

    public int getKeyCode() {
        return this.key;
    }

    public int getModifiers() {
        return this.mods;
    }

    public void setKeyCode(int n) {
        this.key = n;
    }

    public void setModifiers(int n) {
        this.mods = n;
    }

    public void setKeyEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            this.mods = -1;
            this.key = -1;
        } else {
            this.key = keyEvent.getKeyCode();
            this.mods = keyEvent.getModifiers();
            if (this.key == 0) {
                this.key = -keyEvent.getKeyChar();
            }
        }
    }

    public KeyStrokeMenuItem(String string, String string2, KeyEvent keyEvent) {
        super(string, string2);
        this.setKeyEvent(keyEvent);
    }

    public KeyStrokeMenuItem(String string, String string2, int n, int n2) {
        super(string, string2);
        this.setKeyCode(n);
        this.setModifiers(n2);
    }

    public KeyStrokeMenuItem(String string, String string2) {
        this(string, string2, -1, -1);
    }

    @Override
    public String getShortString() {
        String string;
        if (this.mods < 0 || this.key == 0) {
            return none;
        }
        String string2 = KeyEvent.getKeyModifiersText(this.mods);
        String string3 = string = this.key < 0 ? String.valueOf((char)(-this.key)) : KeyEvent.getKeyText(this.key);
        if (string2.equals("")) {
            return string;
        }
        return string2 + "+" + string;
    }

    @Override
    public String getLongString() {
        return super.getLongString() + " : " + this.getShortString();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if (this.capture) {
            if (n == 17 || n == 16 || n == 18 || n == 157 || n == 524) {
                return;
            }
            this.key = n;
            this.mods = n2;
            if (n <= 0) {
                this.key = -c;
            }
            this.capture = false;
            keyEvent.consume();
            this.notifyChanged();
        } else if (n == 10) {
            this.capture = true;
            keyEvent.consume();
            this.notifyUpdated();
        } else if (n == 127) {
            this.setKeyEvent(null);
            this.notifyChanged();
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }
}

