/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import quentinc.audio.Channel;
import quentinc.audio.ChannelGroup;
import quentinc.audio.InternStream;
import quentinc.audio.Sample;
import quentinc.audio.SampleChannel;

class Mixer
extends InternStream
implements ChannelGroup {
    private boolean stopped = false;
    private int max = 32;
    private Collection<InternStream> streams = new CopyOnWriteArrayList<InternStream>();

    Mixer() {
    }

    public int getMaxStreams() {
        return this.max;
    }

    public void setMaxStreams(int n) {
        this.max = n;
    }

    @Override
    public ChannelGroup createSubGroup() {
        return this.createSubGroup(this.max);
    }

    @Override
    public ChannelGroup createSubGroup(int n) {
        Mixer mixer = new Mixer();
        mixer.parent = this;
        mixer.setMaxStreams(n);
        if (this.add(mixer)) {
            return mixer;
        }
        return null;
    }

    @Override
    public Channel play(Sample sample) {
        if (sample == null) {
            return null;
        }
        SampleChannel sampleChannel = sample.createChannel(this, false);
        if (this.add(sampleChannel)) {
            return sampleChannel;
        }
        return null;
    }

    @Override
    public Channel loop(Sample sample) {
        if (sample == null) {
            return null;
        }
        SampleChannel sampleChannel = sample.createChannel(this, true);
        if (this.add(sampleChannel)) {
            return sampleChannel;
        }
        return null;
    }

    protected boolean add(InternStream internStream) {
        if (this.streams.size() < this.max) {
            return this.streams.add(internStream);
        }
        return false;
    }

    protected boolean remove(InternStream internStream) {
        if (this.streams.remove(internStream)) {
            internStream.setActive(false);
            return true;
        }
        return false;
    }

    @Override
    protected int mix(short[] sArray, int n, int n2) {
        if (this.stopped) {
            return -1;
        }
        int n3 = 0;
        for (InternStream internStream : this.streams) {
            n3 = internStream.mix(sArray, n, n2);
            if (n3 > 0) continue;
            this.remove(internStream);
        }
        return n2;
    }

    @Override
    protected void setVol(int n) {
        int n2 = (n << 15) / this.vol;
        super.setVol(n);
        for (InternStream internStream : this.streams) {
            internStream.setVol(n2);
        }
    }

    @Override
    public float getPan() {
        return -1.0f;
    }

    @Override
    public Mixer setPan(float f) {
        return this;
    }

    @Override
    public float getPitch() {
        return -1.0f;
    }

    @Override
    public Mixer setPitch(float f) {
        return this;
    }

    @Override
    public float getPosition() {
        return -1.0f;
    }

    @Override
    public Mixer setPosition(float f) {
        return this;
    }

    @Override
    public float getLength() {
        return -1.0f;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public boolean stop() {
        for (InternStream internStream : this.streams) {
            internStream.close();
        }
        this.stopped = true;
        return true;
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public Mixer setLoop(boolean bl) {
        return this;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public Channel setPaused(boolean bl) {
        for (InternStream internStream : this.streams) {
            internStream.setPaused(bl);
        }
        return this;
    }

    @Override
    public float getVolumeInDb() {
        return InternStream.l2db(this.getVolume());
    }

    @Override
    public Channel setVolumeInDb(float f) {
        return this.setVolume(InternStream.db2l(f));
    }
}

