/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import quentinc.audio.Channel;

abstract class InternStream
implements Channel {
    protected InternStream parent = null;
    protected int vol = 32768;
    protected boolean active = true;

    InternStream() {
    }

    protected abstract int mix(short[] var1, int var2, int var3);

    protected abstract void close();

    protected void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected int getVol() {
        return this.vol;
    }

    protected void setVol(int n) {
        this.vol = this.parent == null ? n : n * this.parent.getVol() >> 15;
        this.vol = Math.max(1, this.vol);
    }

    @Override
    public float getVolume() {
        if (this.parent == null) {
            return (float)this.vol / 32768.0f;
        }
        return 1.0f * (float)this.vol / (float)this.parent.getVol();
    }

    public static float db2l(float f) {
        return (float)Math.pow(10.0, f / 10.0f);
    }

    public static float l2db(float f) {
        return (float)(10.0 * Math.log(f) / Math.log(10.0));
    }

    @Override
    public Channel setVolumeInDb(float f) {
        return this.setVolume(InternStream.db2l(f));
    }

    @Override
    public float getVolumeInDb() {
        return InternStream.l2db(this.getVolume());
    }

    @Override
    public Channel setVolume(float f) {
        this.setVol((int)(f * 32768.0f));
        return this;
    }
}

