/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;

public class Speech {
    public boolean isRateAdjustable() {
        return false;
    }

    public boolean setRate(int n) {
        return false;
    }

    public int getRate() {
        return -1;
    }

    public boolean isVolumeAdjustable() {
        return false;
    }

    public boolean setVolume(int n) {
        return false;
    }

    public int getVolume() {
        return -1;
    }

    public int getMinVolume() {
        return 0;
    }

    public int getMaxVolume() {
        return 100;
    }

    public int getMinRate() {
        return 0;
    }

    public int getMaxRate() {
        return 100;
    }

    public boolean isInterruptible() {
        return false;
    }

    public boolean isPausable() {
        return false;
    }

    public boolean setPaused(boolean bl) {
        return false;
    }

    public boolean sayString(String string, boolean bl) {
        return false;
    }

    public boolean sayString(String string) {
        return this.sayString(string, true);
    }

    public static Speech getInstance() {
        return Speech.getInstance(null);
    }

    public static Speech getInstance(Properties properties) {
        String string;
        if (properties != null && !(string = properties.getProperty("class", "")).equals("")) {
            try {
                Speech speech = Speech.createSpeech(string, properties);
                if (speech != null) {
                    return speech;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return Speech.getDefaultSpeech();
    }

    private static Speech getDefaultSpeech() {
        String string = System.getProperty("os.name").toLowerCase().trim();
        if (string.contains("windows")) {
            try {
                return Speech.createSpeech("quentinc.sapi.SAPISpeech", null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            return Speech.createSpeech("quentinc.accessibility.SpeechDispatcher", null);
        }
        catch (Exception exception) {
            try {
                return Speech.createSpeech("quentinc.accessibility.JavaSpeechAPI", null);
            }
            catch (Exception exception2) {
                return new Speech();
            }
        }
    }

    private static Speech createSpeech(String string, Properties properties) throws Exception {
        Class<?> clazz = Class.forName(string);
        if (properties != null) {
            try {
                Method method = clazz.getMethod("getInstance", Properties.class);
                return (Speech)method.invoke(null, properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (Speech)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (properties != null) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(Properties.class);
                    return (Speech)constructor.newInstance(properties);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            return (Speech)clazz.newInstance();
        }
    }
}

