/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import quentinc.accessibility.Speech;
import quentinc.menu.AbstractMenuItem;
import quentinc.menu.ChoiceMenuItem;
import quentinc.menu.InputMenuItem;
import quentinc.menu.KeyStrokeMenuItem;
import quentinc.menu.Menu;
import quentinc.menu.MenuItem;
import quentinc.menu.MenuListener;
import quentinc.menu.PasswordInputMenuItem;
import quentinc.menu.SpinMenuItem;
import quentinc.menu.ToggleMenuItem;
import quentinc.util.Win32;

public class Test
extends WindowAdapter
implements MenuListener,
KeyListener {
    Menu menu;
    Frame win = new Frame();

    public static void main(String[] stringArray) {
        new Test();
    }

    public void sayString(String string) {
        Speech.getInstance().sayString(string, true);
    }

    public Test() {
        this.win.setTitle("Menu test");
        this.win.addKeyListener(this);
        this.win.addWindowListener(this);
        Set set = Collections.emptySet();
        this.win.setFocusTraversalKeys(0, set);
        this.win.setFocusTraversalKeys(1, set);
        this.win.pack();
        this.win.setVisible(true);
        Locale.setDefault(Locale.US);
        Menu.setStrings(ResourceBundle.getBundle("menuinterf"));
        this.menu = this.createMenu("Menu principal");
        this.menu.setExpanded(true);
        this.createBranch(this.menu, 3, "Item ");
        this.menuChanged(this.menu);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.menu.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.menu.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.menu.keyTyped(keyEvent);
    }

    @Override
    public void menuClicked(AbstractMenuItem abstractMenuItem) {
        System.out.println("Menu clicked : " + abstractMenuItem);
    }

    @Override
    public void menuSelectionChanged(AbstractMenuItem abstractMenuItem, int n) {
        this.sayString(abstractMenuItem.getLongString());
    }

    @Override
    public void menuChanged(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getShortString());
    }

    @Override
    public void menuHelp(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getHelpString());
    }

    @Override
    public void menuUpdated(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getLastUpdateString());
    }

    @Override
    public void menuError(AbstractMenuItem abstractMenuItem, int n) {
        Win32.beep((int)392, (int)100);
    }

    private Menu createMenu(String string) {
        Menu menu = new Menu(string);
        menu.setQuickSelectionOn(true);
        menu.addMenuListener(this);
        return menu;
    }

    private void createBranch(Menu menu, int n, String string) {
        if (n < 0) {
            return;
        }
        block9: for (int i = 1; i <= 7; ++i) {
            switch (i) {
                case 1: {
                    MenuItem menuItem = new SpinMenuItem(string + i, "", "%d%%", 0, 50, 100, 1, 10);
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                    continue block9;
                }
                case 6: {
                    MenuItem menuItem = new InputMenuItem(string + i, "", "Default value", null, null);
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                    continue block9;
                }
                case 3: {
                    Menu menu2 = this.createMenu(string + i);
                    if (n > 0) {
                        menu.add(menu2);
                    }
                    this.createBranch(menu2, n - 1, string + i + ".");
                    continue block9;
                }
                case 4: {
                    MenuItem menuItem = new ToggleMenuItem(string + i, "", false);
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                    continue block9;
                }
                case 2: {
                    MenuItem menuItem = new KeyStrokeMenuItem(string + i, "");
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                    continue block9;
                }
                case 5: {
                    MenuItem menuItem = new ChoiceMenuItem(string + i, "", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten");
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                    continue block9;
                }
                case 7: {
                    MenuItem menuItem = new PasswordInputMenuItem(string + i, "", "Default value");
                    menuItem.addMenuListener(this);
                    menu.add(menuItem);
                }
            }
        }
    }
}

