/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import quentinc.menu.MenuItem;

public class InputMenuItem
extends MenuItem {
    private StringBuffer sb = null;
    private String regex = null;
    private int start = 0;
    private int end = 0;
    private int pos = 0;
    private String oldInput = null;
    private String accept = null;
    private static String selected = "selected";
    private String lastChange = "";
    private static String help = "Edit text using the common edition keys.";

    @Override
    public String getHelpString() {
        return help;
    }

    public static void setStrings(String string, String string2) {
        selected = string;
        help = string2;
    }

    public InputMenuItem(String string, String string2, String string3) {
        this(string, string2, string3, null, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 .");
    }

    public InputMenuItem(String string, String string2, String string3, String string4, String string5) {
        super(string, string2);
        this.accept = string5;
        this.sb = string3 != null ? new StringBuffer(string3) : new StringBuffer("");
        this.regex = string4;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getValue() {
        return this.sb.toString();
    }

    public void setValue(String string) {
        this.sb = new StringBuffer(string);
    }

    @Override
    public String getShortString() {
        return this.getValue();
    }

    @Override
    public String getLongString() {
        return super.getLongString() + " : " + this.getShortString();
    }

    @Override
    public String getLastUpdateString() {
        return this.lastChange;
    }

    public String getSelection() {
        return this.sb.substring(this.start, this.end);
    }

    public void setSelection(String string) {
        if (this.oldInput == null) {
            this.oldInput = this.getValue();
        }
        this.sb.replace(this.start, this.end, string);
        this.start = this.end = this.start + string.length();
        this.pos = this.end;
    }

    public void deleteSelection() {
        if (this.oldInput == null) {
            this.oldInput = this.getValue();
        }
        this.sb.delete(this.start, this.end);
        this.pos = this.end = this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public void setPosition(int n) {
        this.start = this.end = n;
        this.pos = this.end;
    }

    public boolean typeChar(char c) {
        if (this.accept != null && this.accept.indexOf(c) < 0) {
            return false;
        }
        if (this.oldInput == null) {
            this.oldInput = this.getValue();
        }
        if (this.start == this.end) {
            this.sb.insert(this.end, c);
            this.start = ++this.end;
            this.pos = this.end;
        } else {
            this.sb.replace(this.start, this.end, String.valueOf(c));
            this.end = ++this.start;
            this.pos = this.start;
        }
        return true;
    }

    public void typeDelete() {
        if (this.oldInput == null) {
            this.oldInput = this.getValue();
        }
        if (this.start != this.end) {
            this.deleteSelection();
        } else if (this.end < this.sb.length()) {
            this.lastChange = this.end + 1 >= this.sb.length() ? "" : String.valueOf(this.sb.charAt(this.end + 1));
            this.sb.deleteCharAt(this.end);
        } else {
            this.notifyError(0);
        }
    }

    public void typeBackspace() {
        if (this.oldInput == null) {
            this.oldInput = this.getValue();
        }
        if (this.start != this.end) {
            this.deleteSelection();
        } else if (this.end > 0) {
            this.lastChange = String.valueOf(this.sb.charAt(this.end - 1));
            this.sb.deleteCharAt(this.end - 1);
            this.start = --this.end;
            this.pos = this.end;
        } else {
            this.lastChange = "";
            this.notifyError(0);
        }
    }

    public void typeSelRight() {
        this.pos = this.pos == this.end ? ++this.end : ++this.start;
        if (this.end > this.sb.length()) {
            this.end = this.sb.length();
        }
        if (this.start > this.sb.length()) {
            this.start = this.sb.length();
        }
        this.setLastChangeToCurSel();
    }

    public void typeSelLeft() {
        this.pos = this.pos == this.start ? --this.start : --this.end;
        if (this.end < 0) {
            this.end = 0;
        }
        if (this.start < 0) {
            this.start = 0;
        }
        this.setLastChangeToCurSel();
    }

    public void selectAll() {
        this.start = 0;
        this.pos = this.end = this.sb.length();
        this.setLastChangeToCurSel();
    }

    @Override
    public boolean enterItem() {
        this.oldInput = this.getValue();
        this.selectAll();
        return true;
    }

    @Override
    public boolean leaveItem() {
        return this.regex == null || this.getValue().matches(this.regex);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n2 == 1) {
            if (n == 37) {
                this.typeSelLeft();
                keyEvent.consume();
                this.notifyUpdated();
            } else if (n == 39) {
                this.typeSelRight();
                keyEvent.consume();
                this.notifyUpdated();
            } else if (n == 35) {
                this.pos = this.end = this.sb.length();
                keyEvent.consume();
                this.lastChange = this.getSelection() + " : " + selected;
                this.notifyUpdated();
            } else if (n == 36) {
                this.start = 0;
                this.pos = 0;
                keyEvent.consume();
                this.lastChange = this.getSelection() + " : " + selected;
                this.notifyUpdated();
            }
        } else if (n2 == 2) {
            if (n == 67) {
                InputMenuItem.setClipboardContents(this.getSelection());
                keyEvent.consume();
            } else if (n == 86) {
                String string = InputMenuItem.getClipboardContents();
                if (string != null) {
                    this.setSelection(string);
                }
                keyEvent.consume();
            } else if (n == 88) {
                InputMenuItem.setClipboardContents(this.getSelection());
                this.deleteSelection();
                keyEvent.consume();
            } else if (n == 65) {
                this.selectAll();
                this.notifyUpdated();
                keyEvent.consume();
            }
        } else if (n == 37) {
            this.end = --this.pos;
            this.start = this.pos;
            if (this.pos < 0) {
                this.pos = 0;
            }
            if (this.start < 0) {
                this.start = 0;
            }
            if (this.end < 0) {
                this.end = 0;
            }
            this.setLastChangeToCurChar();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 39) {
            this.end = ++this.pos;
            this.start = this.pos;
            if (this.pos > this.sb.length()) {
                this.pos = this.sb.length();
            }
            if (this.start > this.sb.length()) {
                this.start = this.sb.length();
            }
            if (this.end > this.sb.length()) {
                this.end = this.sb.length();
            }
            this.setLastChangeToCurChar();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 36) {
            this.pos = 0;
            this.end = 0;
            this.start = 0;
            this.setLastChangeToCurChar();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 35) {
            this.end = this.pos = this.sb.length();
            this.start = this.pos;
            this.setLastChangeToCurChar();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 127) {
            this.typeDelete();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 8) {
            this.typeBackspace();
            this.notifyUpdated();
            keyEvent.consume();
        } else if (n == 27 && this.oldInput != null) {
            this.sb = new StringBuffer(this.oldInput);
            this.oldInput = null;
            this.lastChange = this.getValue();
            this.selectAll();
            this.notifyUpdated();
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c == '\uffff') {
            return;
        }
        this.typeChar(c);
        keyEvent.consume();
    }

    private void setLastChangeToCurChar() {
        this.lastChange = this.pos >= 0 && this.pos < this.sb.length() ? String.valueOf(this.sb.charAt(this.pos)) : "";
    }

    private void setLastChangeToCurSel() {
        this.lastChange = this.getSelection() + " : " + selected;
    }

    public static void setClipboardContents(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public static String getClipboardContents() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }
}

