/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import quentinc.menu.MenuItem;

public class ChoiceMenuItem
extends MenuItem {
    private final List<String> choices;
    private int curSel = 0;
    private static String help = "Use right and left arrow keys to change the selected option.";

    @Override
    public String getHelpString() {
        return help;
    }

    public static void setStrings(String string) {
        help = string;
    }

    public ChoiceMenuItem(String string, String string2, List<String> list) {
        super(string, string2);
        this.choices = list;
    }

    public ChoiceMenuItem(String string, String string2, Object ... objectArray) {
        this(string, string2, new ArrayList<String>());
        for (Object object : objectArray) {
            this.choices.add(object.toString());
        }
    }

    public int getSelectedIndex() {
        return this.curSel;
    }

    public void setSelectedIndex(int n) {
        this.curSel = n;
    }

    public String getSelectedItem() {
        return this.choices.get(this.curSel);
    }

    @Override
    public String getShortString() {
        return this.choices.get(this.curSel);
    }

    @Override
    public String getLongString() {
        return super.getLongString() + " : " + this.getShortString();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37) {
            this.curSel = (this.curSel + this.choices.size() - 1) % this.choices.size();
            keyEvent.consume();
            this.notifyChanged();
        } else if (n == 39 || n == 32) {
            this.curSel = (this.curSel + 1) % this.choices.size();
            keyEvent.consume();
            this.notifyChanged();
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }
}

