/*
 * Decompiled with CFR 0.152.
 */
package quentinc.game;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Server
implements Runnable {
    ServerSocket sersock;
    Map<String, Connection> conn1 = new ConcurrentHashMap<String, Connection>();
    Map<Integer, Connection> conn2 = new ConcurrentHashMap<Integer, Connection>();

    public Server(int n) throws IOException {
        this.sersock = new ServerSocket(n, 12);
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                while (true) {
                    Socket socket = this.sersock.accept();
                    this.handleConnection(socket);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    public void add(Connection connection) {
        this.conn1.put(connection.getName(), connection);
        this.conn2.put(connection.getId(), connection);
    }

    public void remove(Connection connection) {
        this.conn1.remove(connection.getName());
        this.conn2.remove(connection.getId());
        for (Connection connection2 : this.conn1.values()) {
            connection2.send("deluser " + connection.getId());
        }
    }

    public Connection getConnection(int n) {
        return this.conn2.get(n);
    }

    public Connection getConnection(String string) {
        return this.conn1.get(string);
    }

    public void close() {
        try {
            for (Connection connection : this.conn2.values()) {
                connection.close(false);
            }
            this.conn1.clear();
            this.conn2.clear();
            this.sersock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void handleConnection(final Socket socket) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.println("Connection received");
                Connection connection = null;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    String string = bufferedReader.readLine();
                    if (!string.equals("version 1.0")) {
                        bufferedWriter.write("error version\r\n");
                        bufferedWriter.flush();
                        throw new IOException("Incorrect version : " + string);
                    }
                    if (Server.this.conn1.size() >= 10) {
                        bufferedWriter.write("error full\r\n");
                        bufferedWriter.flush();
                        throw new IOException("Server full !");
                    }
                    String string2 = bufferedReader.readLine().substring(5);
                    if (Server.this.conn1.containsKey(string2)) {
                        bufferedWriter.write("error name\r\n");
                        bufferedWriter.flush();
                        throw new IOException("Name already used : " + string2);
                    }
                    int n = 1;
                    while (Server.this.conn2.containsKey(n)) {
                        ++n;
                    }
                    bufferedWriter.write("id " + n + "\r\n");
                    Object object = Server.this.conn1.values().iterator();
                    while (object.hasNext()) {
                        Connection connection2 = object.next();
                        connection2.send("adduser " + n + " " + string2 + "\r\n");
                        bufferedWriter.write("adduser " + connection2.getId() + " " + connection2.getName() + "\r\n");
                    }
                    bufferedWriter.flush();
                    bufferedWriter.write("hello from server\r\n");
                    bufferedWriter.flush();
                    connection = new Connection(socket, bufferedReader, bufferedWriter, string2, n);
                    Server.this.add(connection);
                    System.out.println("Connection ready in the server side");
                    while ((object = bufferedReader.readLine()) != null) {
                        Server.this.handleMsg(connection, (String)object);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void handleMsg(Connection connection, String string) {
        String string2 = connection.getId() + " " + string;
        for (Connection connection2 : this.conn2.values()) {
            if (connection2 == connection) continue;
            connection2.send(string2);
        }
    }

    class Connection {
        String name;
        int id;
        Socket sock;
        BufferedWriter bw;
        BufferedReader br;

        public Connection(Socket socket, BufferedReader bufferedReader, BufferedWriter bufferedWriter, String string, int n) {
            this.sock = socket;
            this.id = n;
            this.name = string;
            this.br = bufferedReader;
            this.bw = bufferedWriter;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public void send(String string) {
            try {
                this.bw.write(string + "\r\n");
                this.bw.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
            }
        }

        public void close() {
            this.close(true);
        }

        public void close(boolean bl) {
            try {
                if (bl) {
                    Server.this.remove(this);
                }
                this.br.close();
                this.bw.close();
                this.sock.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

