/*
 * Decompiled with CFR 0.152.
 */
package quentinc.game;

import java.util.Set;
import java.util.TreeSet;
import quentinc.game.Point;

public class Board {
    int[][] board;

    public Board(int n, int n2) {
        this.board = new int[n2][n];
    }

    public int get(int n, int n2) {
        return this.board[n2][n];
    }

    public void set(int n, int n2, int n3) {
        this.board[n2][n] = n3;
    }

    public boolean isUsed(int n, int n2) {
        return this.board[n2][n] > 0;
    }

    public boolean isFree(int n, int n2) {
        return this.board[n2][n] <= 0;
    }

    public int get(Point point) {
        return this.get(point.x, point.y);
    }

    public void set(Point point, int n) {
        this.set(point.x, point.y, n);
    }

    public boolean isFree(Point point) {
        return this.isFree(point.x, point.y);
    }

    public boolean isUsed(Point point) {
        return this.isUsed(point.x, point.y);
    }

    public int clear(int n, int n2) {
        int n3 = this.board[n][n2] & 0xFF00;
        this.board[n2][n] = 0;
        while (n2 >= 1 && this.board[n2 - 1][n] > 0) {
            this.board[n2][n] = this.board[n2 - 1][n];
            this.board[n2 - 1][n] = 0;
            --n2;
        }
        return n3;
    }

    public int clear(Point point) {
        return this.clear(point.x, point.y);
    }

    public int clear() {
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[0].length; ++j) {
                this.board[i][j] = 0;
            }
        }
        return 0;
    }

    public int getWidth() {
        return this.board[0].length;
    }

    public int getHeight() {
        return this.board.length;
    }

    public int getTopMostFreeRow(int n) {
        int n2;
        for (n2 = 0; n2 < this.board.length && this.isFree(n, n2); ++n2) {
        }
        return n2 - 1;
    }

    private void checkCell(Point point, Set<Point> set) {
        if (this.board[point.y][point.x] <= 0) {
            return;
        }
        if (set.contains(point)) {
            return;
        }
        set.add(point);
        if (point.x < this.getWidth() - 1 && (this.board[point.y][point.x] & 0xFF) == (this.board[point.y][point.x + 1] & 0xFF)) {
            this.checkCell(new Point(point.x + 1, point.y), set);
        }
        if (point.x > 0 && (this.board[point.y][point.x] & 0xFF) == (this.board[point.y][point.x - 1] & 0xFF)) {
            this.checkCell(new Point(point.x - 1, point.y), set);
        }
        if (point.y < this.getHeight() - 1 && (this.board[point.y][point.x] & 0xFF) == (this.board[point.y + 1][point.x] & 0xFF)) {
            this.checkCell(new Point(point.x, point.y + 1), set);
        }
        if (point.y > 0 && (this.board[point.y][point.x] & 0xFF) == (this.board[point.y - 1][point.x] & 0xFF)) {
            this.checkCell(new Point(point.x, point.y - 1), set);
        }
    }

    public int check() {
        int n = 0;
        int n2 = 0;
        TreeSet<Point> treeSet = new TreeSet<Point>();
        int n3 = this.getWidth();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getHeight();
            for (int j = 0; j < n4; ++j) {
                if (this.isFree(i, j)) continue;
                treeSet.clear();
                Point point = new Point(i, j);
                this.checkCell(point, treeSet);
                if (treeSet.size() < 3) continue;
                n += treeSet.size();
                for (Point point2 : treeSet) {
                    n2 |= this.clear(point2);
                }
            }
        }
        return n | n2;
    }
}

