/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import quentinc.audio.AudioManager;
import quentinc.audio.InternStream;
import quentinc.audio.Mixer;
import quentinc.audio.Sample;
import quentinc.audio.StreamChannel;

public class StreamedSample
extends Sample
implements Runnable {
    private AudioInputStream stream;
    protected StreamChannel channel;
    protected Thread thr;
    protected boolean finished = false;
    private static final int BUFSIZE = 44100;
    private static final int SBUFSIZE = 4096;

    protected StreamedSample(Object object, AudioInputStream audioInputStream, int n) throws IOException {
        super(object, new short[n + 2], (int)audioInputStream.getFormat().getSampleRate(), audioInputStream.getFormat().getChannels() == 1);
        this.res = object;
        this.prepare(audioInputStream);
    }

    @Override
    protected StreamChannel createChannel(Mixer mixer, boolean bl) {
        if (this.channel != null) {
            return null;
        }
        this.channel = new StreamChannel((InternStream)mixer, this, bl);
        this.channel.setVolume(this.defaultVol);
        return this.channel;
    }

    @Override
    public void run() {
        boolean bl = this.stream.getFormat().getSampleSizeInBits() == 8;
        boolean bl2 = this.stream.getFormat().isBigEndian();
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = this.length;
        if (!this.mono) {
            n2 *= 2;
        }
        try {
            while (this.thr != null && !this.finished) {
                while (this.thr != null && !this.finished && (n = this.stream.read(byArray, 0, byArray.length)) > 0) {
                    int n3 = this.limit;
                    for (int i = 0; i < n; ++i) {
                        while (this.channel == null || this.limit <= this.channel.pos && (this.limit + 1) % n2 > this.channel.pos) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                break;
                            }
                        }
                        if (bl) {
                            this.data[n3++] = (short)(byArray[i] << 8);
                        } else {
                            this.data[n3++] = (short)((byArray[i++] << (bl2 ? 8 : 0)) + (byArray[i] << (bl2 ? 0 : 8)));
                        }
                        if (n3 >= this.data.length - 2) {
                            n3 -= this.data.length - 2;
                        }
                        this.limit = (this.limit + 1) % n2;
                    }
                }
                if (this.thr != null && !this.thr.isInterrupted() && this.channel != null && this.channel.loop && n <= 0 && this.reload()) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.finished = true;
        this.channel = null;
        this.thr = null;
    }

    protected void prepare(AudioInputStream audioInputStream) throws IOException {
        this.stream = AudioManager.getInstance().translateStream(audioInputStream);
        this.limit = 1;
        this.finished = false;
        this.length = this.data.length - 2 >> (this.mono ? 0 : 1);
        if (this.thr == null) {
            this.thr = new Thread(this);
            this.thr.setDaemon(true);
            this.thr.start();
        }
    }

    protected boolean reload() throws IOException {
        try {
            if (this.res == null) {
                return false;
            }
            this.stream.close();
            if (this.res instanceof File) {
                this.prepare(AudioSystem.getAudioInputStream((File)this.res));
            } else if (this.res instanceof URL) {
                this.prepare(AudioSystem.getAudioInputStream((URL)this.res));
            }
            return true;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public static StreamedSample load(File file) throws IOException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            return new StreamedSample(file, audioInputStream, 44100);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public static StreamedSample load(URL uRL) throws IOException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            return new StreamedSample(uRL, audioInputStream, 44100);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public static StreamedSample load(InputStream inputStream) throws IOException {
        try {
            return StreamedSample.load(AudioSystem.getAudioInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException(unsupportedAudioFileException);
        }
    }

    public static StreamedSample load(AudioInputStream audioInputStream) throws IOException {
        return new StreamedSample(null, audioInputStream, 44100);
    }

    public void finalize() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
            super.finalize();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

