/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import quentinc.audio.Mixer;

public class AudioManager
extends Mixer
implements Runnable {
    private static final int BUFSIZE = 1024;
    private static final float DEFBUFLEN = 0.07f;
    private short[] buf;
    private byte[] bufb;
    private SourceDataLine out;
    private Thread thr;
    private static AudioManager singleton;

    private AudioManager() {
    }

    public static AudioManager getInstance() {
        if (singleton == null) {
            singleton = new AudioManager();
        }
        return singleton;
    }

    public boolean isOpen() {
        return this.out != null;
    }

    @Override
    public void close() {
        this.stop();
        this.out.close();
        this.out = null;
    }

    public void open(int n, int n2) throws LineUnavailableException {
        this.open(n, n2, 0.07f);
    }

    public void open(int n, int n2, float f) throws LineUnavailableException {
        int n3 = (int)(f * (float)n * 4.0f);
        this.out = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, new AudioFormat(n, 16, 2, true, false), n3));
        this.out.open();
        this.setMaxStreams(n2);
        this.buf = new short[1024];
        this.bufb = new byte[2048];
    }

    public boolean start() {
        this.thr = new Thread((Runnable)this, "Audio thread");
        this.thr.start();
        return true;
    }

    @Override
    public boolean stop() {
        super.stop();
        this.thr.interrupt();
        this.thr = null;
        return true;
    }

    @Override
    public void run() {
        this.out.start();
        while (this.thr != null) {
            int n;
            for (n = 0; n < 1024; ++n) {
                this.buf[n] = 0;
            }
            int n2 = this.mix(this.buf, 0, this.buf.length);
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                this.bufb[n3++] = (byte)(this.buf[n] & 0xFF);
                this.bufb[n3++] = (byte)(this.buf[n] >> 8);
            }
            this.out.write(this.bufb, 0, n3);
        }
        this.out.flush();
        this.out.stop();
    }

    public AudioFormat getFormat() {
        return this.out.getFormat();
    }

    public float getSampleRate() {
        return this.out.getFormat().getSampleRate();
    }

    public float getLatency() {
        return (float)this.out.getBufferSize() / (this.getSampleRate() * 4.0f);
    }

    protected AudioInputStream translateStream(AudioInputStream audioInputStream) {
        if (!audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, audioFormat.isBigEndian());
            AudioFormat audioFormat3 = new AudioFormat(audioFormat.getSampleRate(), 8, audioFormat.getChannels(), true, audioFormat.isBigEndian());
            if (AudioSystem.isConversionSupported(audioFormat2, audioFormat)) {
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            } else if (AudioSystem.isConversionSupported(audioFormat3, audioFormat)) {
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat3, audioInputStream);
            } else {
                return null;
            }
        }
        return audioInputStream;
    }
}

