/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.Properties;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.Voice;
import quentinc.accessibility.Speech;

public class JSAPI
extends Speech {
    private Synthesizer synth = null;

    public JSAPI(Properties properties) throws AudioException, EngineException, PropertyVetoException {
        String string;
        String string2;
        int n = 65535;
        String string3 = properties.getProperty("voicegender", "null").toLowerCase();
        if (string3.equals("male")) {
            n = 2;
        } else if (string3.equals("female")) {
            n = 1;
        } else if (string3.equals("neutral")) {
            n = 4;
        }
        int n2 = 65535;
        String string4 = properties.getProperty("voiceage", "null").toLowerCase();
        if (string4.equals("child")) {
            n2 = 1;
        } else if (string4.equals("teenager")) {
            n2 = 2;
        } else if (string4.equals("younger adult")) {
            n2 = 4;
        } else if (string4.equals("adult") || string4.equals("middle adult")) {
            n2 = 8;
        } else if (string4.equals("older adult")) {
            n2 = 16;
        } else if (string4.equals("neutral")) {
            n2 = 32;
        }
        String string5 = properties.getProperty("voicename", null);
        if (string5 != null && (string5.equals("") || string5.equals("null"))) {
            string5 = null;
        }
        if ((string2 = properties.getProperty("voicestyle", null)) != null && (string2.equals("") || string2.equals("null"))) {
            string2 = null;
        }
        if ((string = properties.getProperty("engine", null)) != null && (string.equals("") || string.equals("null"))) {
            string = null;
        }
        SynthesizerModeDesc synthesizerModeDesc = new SynthesizerModeDesc(string, "general", Locale.getDefault(), null, null);
        SynthesizerModeDesc synthesizerModeDesc2 = new SynthesizerModeDesc(string, "general", Locale.US, null, null);
        Voice voice = new Voice(string5, n, n2, string2);
        Synthesizer synthesizer = Central.createSynthesizer((EngineModeDesc)synthesizerModeDesc);
        if (synthesizer == null) {
            synthesizer = Central.createSynthesizer((EngineModeDesc)synthesizerModeDesc2);
        }
        if (synthesizer == null) {
            throw new RuntimeException("Could not find synthesizer");
        }
        synthesizer.allocate();
        SynthesizerProperties synthesizerProperties = synthesizer.getSynthesizerProperties();
        synthesizerProperties.setVoice(voice);
        float f = (float)Double.parseDouble(properties.getProperty("pitch", "-1"));
        float f2 = (float)Double.parseDouble(properties.getProperty("pitchrange", "-1"));
        float f3 = (float)Double.parseDouble(properties.getProperty("rate", "-1"));
        float f4 = (float)Double.parseDouble(properties.getProperty("volume", "-1"));
        if (f > 0.0f) {
            synthesizerProperties.setPitch(f);
        }
        if (f2 > 0.0f) {
            synthesizerProperties.setPitchRange(f2);
        }
        if (f3 > 0.0f) {
            synthesizerProperties.setSpeakingRate(f3);
        }
        if (f4 > 0.0f) {
            synthesizerProperties.setVolume(f4);
        }
        synthesizer.resume();
        this.synth = synthesizer;
    }

    public boolean stopSpeech() {
        try {
            this.synth.pause();
            this.synth.cancelAll();
            this.synth.resume();
        }
        catch (AudioException audioException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        if (bl) {
            this.stopSpeech();
        }
        this.synth.speakPlainText(string, null);
        return true;
    }

    public void finalize() throws Exception {
        this.stopSpeech();
        this.synth.deallocate();
    }
}

