/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import quentinc.accessibility.Speech;

public class ECI
extends Speech {
    private static final int GENDER = 0;
    private static final int HEADSIZE = 1;
    private static final int PITCH = 2;
    private static final int PITCH_FLUCTUATION = 3;
    private static final int ROUGHNESS = 4;
    private static final int BREATHINESS = 5;
    private static final int SPEED = 6;
    private static final int VOLUME = 7;
    private static final int ANNOTATION_PROCESSING = 1;
    private static final int SPELLING_MODE = 2;
    private static final int LANGUAGE = 9;
    public static final int GENDER_MALE = 0;
    public static final int GENDER_FEMALE = 1;
    public static final int SPELLING_OFF = 0;
    public static final int SPELLING_LETTERS = 1;
    public static final int SPELLING_ALL = 2;
    public static final int eciGeneralAmericanEnglish = 65536;
    public static final int eciBritishEnglish = 65537;
    public static final int eciCastilianSpanish = 131072;
    public static final int eciMexicanSpanish = 131073;
    public static final int eciStandardFrench = 196608;
    public static final int eciCanadianFrench = 196609;
    public static final int eciStandardGerman = 262144;
    public static final int eciStandardItalian = 327680;
    public static final int eciMandarinChinese = 393216;
    public static final int eciMandarinChineseGB = 393216;
    public static final int eciMandarinChinesePinYin = 393472;
    public static final int eciMandarinChineseUCS = 395264;
    public static final int eciTaiwaneseMandarin = 393217;
    public static final int eciTaiwaneseMandarinBig5 = 393217;
    public static final int eciTaiwaneseMandarinZhuYin = 393473;
    public static final int eciTaiwaneseMandarinPinYin = 393729;
    public static final int eciTaiwaneseMandarinUCS = 395265;
    public static final int eciBrazilianPortuguese = 458752;
    public static final int eciStandardJapanese = 524288;
    public static final int eciStandardJapaneseSJIS = 524288;
    public static final int eciStandardJapaneseUCS = 526336;
    public static final int eciStandardFinnish = 589824;
    public static final int eciStandardKorean = 655360;
    public static final int eciStandardKoreanUHC = 655360;
    public static final int eciStandardKoreanUCS = 657408;
    public static final int eciStandardCantonese = 720896;
    public static final int eciStandardCantoneseGB = 720896;
    public static final int eciStandardCantoneseUCS = 722944;
    public static final int eciHongKongCantonese = 720897;
    public static final int eciHongKongCantoneseBig5 = 720897;
    public static final int eciHongKongCantoneseUCS = 722945;
    public static final int eciStandardDutch = 786432;
    public static final int eciStandardNorwegian = 851968;
    public static final int eciStandardSwedish = 917504;
    public static final int eciStandardDanish = 983040;
    private static final Map<String, Integer> languages = new HashMap<String, Integer>();
    private Pointer ptr;

    private static native Pointer eciNew();

    private static native Pointer eciNewEx(int var0);

    private static native int eciSetParam(Pointer var0, int var1, int var2);

    private static native int eciGetParam(Pointer var0, int var1);

    private static native int eciSetVoiceParam(Pointer var0, int var1, int var2, int var3);

    private static native int eciGetVoiceParam(Pointer var0, int var1, int var2);

    private static native boolean eciAddText(Pointer var0, String var1);

    private static native boolean eciSynthesize(Pointer var0);

    private static native boolean eciSetOutputFilename(Pointer var0, String var1);

    private static native boolean eciPause(Pointer var0, boolean var1);

    private static native boolean eciStop(Pointer var0);

    private static native boolean eciSpeaking(Pointer var0);

    private static native boolean eciSynchronize(Pointer var0);

    private static int getLanguage(String string) {
        if (languages.containsKey(string)) {
            return languages.get(string);
        }
        return -1;
    }

    private static int getLanguage(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        int n = -1;
        if (string != null && string2 != null && n == -1) {
            n = ECI.getLanguage(string + "-" + string2);
        }
        if (string != null && n == -1) {
            n = ECI.getLanguage(string);
        }
        return n;
    }

    public static Speech getInstance(Properties properties) {
        Object object;
        String string = "auto";
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (properties != null) {
            string = properties.getProperty("language", string);
            n = Integer.parseInt(properties.getProperty("rate", "-1"));
            n4 = Integer.parseInt(properties.getProperty("pitch", "-1"));
            n5 = Integer.parseInt(properties.getProperty("pitchFluctuation", "-1"));
            n7 = Integer.parseInt(properties.getProperty("headSize", "-1"));
            n2 = Integer.parseInt(properties.getProperty("breathiness", "-1"));
            n6 = Integer.parseInt(properties.getProperty("roughness", "-1"));
            object = properties.getProperty("gender", "").toLowerCase().trim();
            if (((String)object).equals("male")) {
                n3 = 0;
            } else if (((String)object).equals("female")) {
                n3 = 1;
            }
        }
        object = null;
        object = string != null && string.equals("auto") ? new ECI(Locale.getDefault()) : (string != null && string.startsWith("0x") ? new ECI(Integer.decode(string)) : (string != null ? new ECI(string) : new ECI()));
        if (n3 >= 0) {
            ((ECI)object).setVoiceGender(n3);
        }
        if (n7 >= 0) {
            ((ECI)object).setHeadSize(n7);
        }
        if (n6 >= 0) {
            ((ECI)object).setRoughness(n6);
        }
        if (n2 >= 0) {
            ((ECI)object).setBreathiness(n2);
        }
        if (n5 >= 0) {
            ((ECI)object).setPitchFluctuation(n5);
        }
        if (n4 >= 0) {
            ((ECI)object).setPitch(n4);
        }
        if (n >= 0) {
            ((ECI)object).setRate(n);
        }
        return object;
    }

    public ECI() {
        this.init(-1);
    }

    public ECI(int n) {
        this.init(n);
    }

    public ECI(String string) {
        this.init(ECI.getLanguage(string));
    }

    public ECI(Locale locale) {
        this.init(ECI.getLanguage(locale));
    }

    private void init(int n) {
        this.ptr = n < 0 ? ECI.eciNew() : ECI.eciNewEx(n);
        ECI.eciSetParam(this.ptr, 0, 1);
        ECI.eciSetParam(this.ptr, 8, 1);
    }

    public boolean addText(String string) {
        return ECI.eciAddText(this.ptr, string);
    }

    public boolean synthesize() {
        return ECI.eciSynthesize(this.ptr);
    }

    public boolean setOutputFilename(String string) {
        return ECI.eciSetOutputFilename(this.ptr, string);
    }

    @Override
    public boolean setPaused(boolean bl) {
        return ECI.eciPause(this.ptr, bl);
    }

    public boolean stopSpeech() {
        return ECI.eciStop(this.ptr);
    }

    public boolean isSpeaking() {
        return ECI.eciSpeaking(this.ptr);
    }

    public boolean join() {
        return ECI.eciSynchronize(this.ptr);
    }

    public boolean setSpellingMode(int n) {
        return n == ECI.eciSetParam(this.ptr, 2, n);
    }

    public int getSpellingMode() {
        return ECI.eciGetParam(this.ptr, 2);
    }

    public void setAnnotationsProcessing(boolean bl) {
        ECI.eciSetParam(this.ptr, 1, bl ? 1 : 0);
    }

    public boolean areAnnotationProcessed() {
        return ECI.eciGetParam(this.ptr, 1) >= 0;
    }

    public boolean setLanguage(Locale locale) {
        int n = ECI.getLanguage(locale);
        if (n >= 0) {
            return n == ECI.eciSetParam(this.ptr, 9, n);
        }
        return false;
    }

    public boolean setLanguage(String string) {
        int n = ECI.getLanguage(string);
        if (n >= 0) {
            return n == ECI.eciSetParam(this.ptr, 9, n);
        }
        return false;
    }

    public boolean setLanguage(int n) {
        return n == ECI.eciSetParam(this.ptr, 9, n);
    }

    public boolean setParam(int n, int n2) {
        return n2 == ECI.eciSetParam(this.ptr, n, n2);
    }

    public int getParam(int n) {
        return ECI.eciGetParam(this.ptr, n);
    }

    public boolean setVoiceParam(int n, int n2) {
        return n2 == ECI.eciSetVoiceParam(this.ptr, 0, n, n2);
    }

    public int getVoiceParam(int n) {
        return ECI.eciGetVoiceParam(this.ptr, 0, n);
    }

    @Override
    public boolean setRate(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 6, n);
    }

    @Override
    public int getRate() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 6);
    }

    public boolean setPitch(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 2, n);
    }

    public int getPitch() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 2);
    }

    public boolean setPitchFluctuation(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 3, n);
    }

    public int getPitchFluctuation() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 3);
    }

    @Override
    public boolean setVolume(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 7, n);
    }

    @Override
    public int getVolume() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 7);
    }

    public boolean setBreathiness(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 5, n);
    }

    public int getBreathiness() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 5);
    }

    public boolean setRoughness(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 4, n);
    }

    public int getRoughness() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 4);
    }

    public boolean setHeadSize(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 1, n);
    }

    public int getHeadSize() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 1);
    }

    public boolean setVoiceGender(int n) {
        return n == ECI.eciSetVoiceParam(this.ptr, 0, 0, n);
    }

    public int getVoiceGender() {
        return ECI.eciGetVoiceParam(this.ptr, 0, 0);
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public boolean isPausable() {
        return true;
    }

    @Override
    public boolean isVolumeAdjustable() {
        return true;
    }

    @Override
    public boolean isRateAdjustable() {
        return true;
    }

    @Override
    public int getMinRate() {
        return 120;
    }

    @Override
    public int getMaxRate() {
        return 380;
    }

    @Override
    public int getMinVolume() {
        return 1;
    }

    @Override
    public int getMaxVolume() {
        return 65535;
    }

    public int getMinPitch() {
        return 40;
    }

    public int getMaxPitch() {
        return 422;
    }

    public int getMinPitchFluctuation() {
        return 0;
    }

    public int getMaxPitchFluctuation() {
        return 100;
    }

    public int getMinBreathiness() {
        return 0;
    }

    public int getMaxBreathiness() {
        return 100;
    }

    public int getMinRoughness() {
        return 0;
    }

    public int getMaxRoughness() {
        return 100;
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        if (bl) {
            ECI.eciStop(this.ptr);
        }
        return ECI.eciAddText(this.ptr, string) && ECI.eciSynthesize(this.ptr);
    }

    static {
        Native.register((String)"eci");
        languages.put("en", 65536);
        languages.put("en-GB", 65537);
        languages.put("es", 131072);
        languages.put("es-MX", 131073);
        languages.put("fr", 196608);
        languages.put("fr-CA", 196609);
        languages.put("de", 262144);
        languages.put("it", 327680);
        languages.put("pt", 458752);
        languages.put("ja", 524288);
        languages.put("fi", 589824);
        languages.put("no", 851968);
        languages.put("sv", 917504);
    }
}

